<?php 
include 'header-link.php'; 

// Fetching data from database
$sql = "SELECT * FROM money_rate ORDER BY id DESC";
$result = $con->query($sql);
$rates = [];

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $rates[] = $row;
    }
}

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['delete_id'])) {
    $delete_id = $_POST['delete_id'];
    $delete_sql = "DELETE FROM money_rate WHERE id = ?";
    $stmt = $con->prepare($delete_sql);
    $stmt->bind_param("i", $delete_id);
    $stmt->execute();
    header("Location: money-rate-list.php");
    exit();
}
?>

<main>
    <section>
        <div class="container mt-2 pb-5">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="card custom-card">
                        <div class="card-body">
                            <div class="text-center">
                                <i class="profile-icon fa-solid fa-money-bill-trend-up"></i>
                            </div>

                            <h6 class="card-title text-center my-3">Money Rate List</h6>
                            <a class="btn btn-info m-3 d-block text-center" href="money-rate-add.php">Add New</a>

                            <!-- List of Money Rates -->
                            <div class="offer-list" id="offerList">
                                <?php if (!empty($rates)): ?>
                                    <?php foreach ($rates as $rate): ?>
                                        <div class="offer-card mb-3 p-4">
                                            <div class="row">
                                                <div class="col-md-12 text-left">
                                                    <small><span class="fw-bold">Title</span>: <strong><?php echo htmlspecialchars($rate['title']); ?></strong></small><br>
                                                    <small><span class="fw-bold">Date:</span> <?php echo htmlspecialchars($rate['date']); ?></small><br>
                                                    <small><span class="fw-bold">Rate:</span> <strong><?php echo htmlspecialchars($rate['message']); ?></strong></small><br>
                                                    
                                                    <!-- Delete Form -->
                                                <div class="d-grid text-center">    
                                                    <form action="" method="POST" style="display:inline;">
                                                        <input type="hidden" name="delete_id" value="<?php echo $rate['id']; ?>">
                                                        <button type="submit" class="btn custom-button w-50 mx-auto" onclick="return confirm('Are you sure you want to delete this entry?')">
                                                            <i class="font fa-solid fa-trash"></i> Delete
                                                        </button>
                                                    </form>
                                                </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <p>No money rates available.</p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>

</body>
</html>
